import { View, Text, Pressable, Animated } from "react-native";
import React, { useState, useEffect } from "react";
import ProgressiveImage from "../../../../../../../src/components/ProgressiveImage";
import MinusIcon from "../../../../../../../assets/svgs/cart/minus.svg";
import PlusIcon from "../../../../../../../assets/svgs/cart/plus.svg";
import { groupProductStyle } from "./groupProduct.style";
import useProcessPrice from "../../../../../../../hooks/useProcessPrice";
import { calculateVariationPrice } from "./calculateVariationPrice";
import * as Linking from "expo-linking";
import useAuth from "../../../../../../../hooks/useAuth";
import { query } from "../../../../../../../redux/slices/util/apiRequest";
import dpr from "../../../../../../Utilities/CustomStyleAttribute/dpr";
import VariationContent from "../VariableProduct/VariationContent";
import { useDispatch } from "react-redux";
import { resetVariation } from "../../../../../../../redux/slices/featureProducts/items/itemVariations";
import IndividualItemStock from "./IndividualItemStock";
import { BASE_API_URL_STG } from "@env";
import useCustomNavigation from "../../../../../../../hooks/useCustomNavigation";
import { useRef } from "react";
import {
    closeModal,
    modalHeight,
    openModal,
} from "../../../../../../../src/components/CustomModal/modalHelper";
import useLangTranslation from "../../../../../../../hooks/useLangTranslation";
import { compareWithTodaysDate } from "../../../../../../../helper/compareWithTodaysDate";
import usePreferences from "../../../../../../../hooks/usePreferences";
import { PRODUCT_DETAILS } from "../../../../../../../components/Navigation/RouteNames";
import CustomSVG from "../../../../../../../src/components/CustomSVG/CustomSVG";

const IndividualItem = ({ item, setDisableBtn, inputData, setInputData }) => {
    const { trans } = useLangTranslation();
    const navigation = useCustomNavigation();
    const dispatch = useDispatch();
    const processPrice = useProcessPrice();
    const { access_token } = useAuth();
    const [quantity, setQuantity] = useState(0);
    const [stockAvailable, setStockAvailable] = useState(false)
    const [selectedDimensions, setSelectedDimensions] = useState({
        width: "",
        height: "",
        length: "",
    });

    const {
        product_inventory: {
            manage_stock: preferenceManageStock,
        } = {},
    } = usePreferences();

    const {
        name,
        type,
        slug,
        code,
        regular_price,
        sale_price,
        manage_stocks,
        total_stocks,
        stock_status,
        critical_stock_quantity,
        backorders,
        stock_hide,
        individual_sale,
        variations,
        feature_image,
        url,
        text,
        sale_from,
        sale_to,
    } = item || {};
    let isSaleAvailable = compareWithTodaysDate(sale_from, sale_to);

    let price;
    if (type == "Variable Product") {
        price = calculateVariationPrice(variations, processPrice);
    }

    useEffect(() => {
        if (inputData?.group_products?.length == 0) {
            setDisableBtn(true);
        } else {
            setDisableBtn(false);
        }
    }, [inputData]);

    useEffect(() => {
        const hasProperty = inputData?.hasOwnProperty("group_products");
        if (!hasProperty) {
            setInputData({
                ...inputData,
                group_products: [],
                is_group_product: 1,
            });
        }
        if (quantity > 0 && inputData?.group_products?.length == 0) {
            setInputData({
                ...inputData,
                group_products: [{ code, qty: quantity }],
            });
        } else if (inputData?.group_products?.length > 0) {
            let isCode;
            isCode = inputData?.group_products?.find(
                (item) => item.code == code
            );
            if (isCode != undefined) {
                setInputData({
                    ...inputData,
                    group_products: inputData?.group_products
                        ?.map((item) => {
                            if (item?.code == isCode?.code) {
                                return {
                                    ...item,
                                    qty: quantity,
                                };
                            } else {
                                return item;
                            }
                        })
                        .filter((item) => item.qty !== 0),
                });
            } else {
                setInputData({
                    ...inputData,
                    group_products: [
                        ...inputData?.group_products,
                        { code, qty: quantity },
                    ],
                });
            }
        }
    }, [quantity]);
    
    const handleIncrement = () => {
        setQuantity((prev) => {
            if (individual_sale == "1") {
                return 1;
            }
            if (
                manage_stocks == 0 ||
                stock_status.toLowerCase() != "out of stock" ||
                backorders == 1 ||
                prev < total_stocks
            ) {
                if(manage_stocks == 0) {
                    return prev + 1;
                }
                if(prev == total_stocks) {
                    return prev;
                }
                return prev + 1;
            }
            return prev;
        });
    };
    const handleDecrement = () => {
        setQuantity((prev) => {
            if (prev <= 0) {
                return 0;
            }
            return prev - 1;
        });
    };

    const [products, setProducts] = useState([]);
    useEffect(() => {
        (async () => {
            const productDetailsUrl = `${BASE_API_URL_STG}/user/product/${slug}`;
            let isMounted = true;
            if (isMounted && type == "Variable Product") {
                try {
                    const singleItem = await query(
                        productDetailsUrl,
                        "GET",
                        access_token
                    );
                    if (singleItem?.data?.id) {
                        setProducts([...products, singleItem]);
                    }
                } catch (error) {}
            }
            return () => {
                isMounted = false;
            };
        })()
    }, []);

    useEffect(() => {
        if(preferenceManageStock == "0" ||
        (preferenceManageStock == "1" && manage_stocks == "0")
        ){
            stock_status?.toLowerCase() == "out of stock" ? setStockAvailable(false) : setStockAvailable(true);
        } else if (preferenceManageStock == "1" && manage_stocks == "1" && stock_hide != 1){
            if(backorders == 1) {
                setStockAvailable(true)
            } else {
                total_stocks <= 0 ? setStockAvailable(false) : setStockAvailable(true)
            }
        }
    }, [])

    const [productDetails, setProductDetails] = useState(null);
    const [isVisible, setIsVisible] = useState(false);
    const modalY = useRef(new Animated.Value(modalHeight)).current;
    const onOpenModal = (id) => {
        const singleProduct = products.find(
            (product) => product?.data?.id == id
        );
        setProductDetails(singleProduct);
        openModal(setIsVisible, modalY);
    };
    const onCloseModal = () => {
        dispatch(resetVariation());
        closeModal(setIsVisible, modalY);
    };

    return (
        <View style={groupProductStyle.individualCont}>
            <ProgressiveImage
                source={{ uri: feature_image }}
                style={groupProductStyle.image}
            />
            <Pressable
                onPress={() => {
                    navigation.push(PRODUCT_DETAILS, {
                        slug: slug,
                        item
                    });
                }}
            >
                <View>
                    <Text style={groupProductStyle.name} numberOfLines={2}>
                        {name}
                    </Text>
                    {(type == "Simple Product" ||
                        type == "External/Affiliate Product") && (
                        <Text style={groupProductStyle.price}>
                            {processPrice(
                                (isSaleAvailable && sale_price) || regular_price
                            )}
                        </Text>
                    )}
                    {type == "Variable Product" &&
                        ((isSaleAvailable && price.salePrice) ||
                            price.regularPrice) && (
                            <Text style={groupProductStyle.price}>
                                {(isSaleAvailable && price.salePrice) ||
                                    price.regularPrice}
                            </Text>
                        )}
                    {type == "Simple Product" && (
                        <IndividualItemStock
                            stockManage={{
                                manage_stocks,
                                stock_status,
                                total_stocks,
                                critical_stock_quantity,
                                stock_hide,
                                backorders
                            }}
                        />
                    )}
                </View>
            </Pressable>
            {type == "Simple Product" && (
                <View style={groupProductStyle.quantityCont}>
                    <Pressable
                        onPress={handleDecrement}
                        style={groupProductStyle.qtyBtn}
                    >
                        <CustomSVG svgIcon={MinusIcon}
                            fill={"#898989"}
                            height={dpr(10)}
                            width={dpr(10)}
                        />
                    </Pressable>
                    <Text style={groupProductStyle.quantity}>{quantity}</Text>
                    <Pressable
                        disabled={stockAvailable == true ? false : true}
                        onPress={handleIncrement}
                        style={[
                            groupProductStyle.qtyBtn,
                            groupProductStyle.plusBtn,
                        ]}
                    >
                        <CustomSVG svgIcon={PlusIcon}
                            fill={"#898989"}
                            height={dpr(10)}
                            width={dpr(10)}
                        />
                    </Pressable>
                </View>
            )}
            {type == "Variable Product" && (
                <Pressable
                    onPress={() => products.length > 0 && onOpenModal(item?.id)}
                    style={[
                        groupProductStyle.quantityCont,
                        groupProductStyle.optionCont,
                    ]}
                >
                    <Text style={groupProductStyle.option}>
                        {trans("Option")}
                    </Text>
                </Pressable>
            )}
            {type == "External/Affiliate Product" && (
                <Pressable
                    onPress={() => Linking.openURL(url)}
                    style={[
                        groupProductStyle.quantityCont,
                        groupProductStyle.optionCont,
                    ]}
                >
                    <Text style={groupProductStyle.option}>{text}</Text>
                </Pressable>
            )}
            {isVisible && productDetails != null && (
                <VariationContent
                    isVisible={isVisible}
                    modalY={modalY}
                    onCloseModal={onCloseModal}
                    productDetails={productDetails}
                    setSelectedDimensions={setSelectedDimensions}
                />
            )}
        </View>
    );
};

export default IndividualItem;
